
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'PDV_VD_TEF_PARC')
BEGIN
	CREATE TABLE  PDV_VD_TEF_PARC (
		CD_EMP  int  NOT NULL,
		CD_FILIAL  int  NOT NULL,
		CD_VD  int  NOT NULL,
		CD_CTR  int  NOT NULL,
		PARC  Tinyint  NOT NULL,
		DT_VENCTO DATE NOT NULL,
		VLR_TX MONEY,
		VLR_PARC_CARTAO			MONEY NOT NULL DEFAULT(0),
		VLR_PARC_SAQUE_CARTAO 	MONEY NOT NULL DEFAULT(0),
		VLR_PARC_TOTAL_DOACAO 	MONEY NOT NULL DEFAULT(0),
		NSU_SITEF				MONEY NULL,
		NR_COMPROVANTE			VARCHAR (50) NULL,
		ID_TRANSACAO		INT NULL,
		VLR_LIQ_LJ			MONEY NULL,
		DT_PREV_PAG_LJ		DATE NULL
 
	 CONSTRAINT PK_PDV_VD_TEF_PARC  PRIMARY KEY CLUSTERED 
	(
		CD_EMP  ASC,
		CD_FILIAL  ASC,
		CD_VD  ASC,
		CD_CTR  ASC,
		PARC  ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY] 
	) ON [PRIMARY] 
 
	ALTER TABLE PDV_VD_TEF_PARC   WITH CHECK ADD  CONSTRAINT FK_PDV_VD_TEF_PARC_PDV_VD_TEF  FOREIGN KEY(CD_EMP , CD_FILIAL , CD_VD , CD_CTR )
	REFERENCES dbo .PDV_VD_TEF  (CD_EMP , CD_FILIAL , CD_VD , CD_CTR )
	ON UPDATE CASCADE
	ON DELETE CASCADE
 

	ALTER TABLE PDV_VD_TEF_PARC  CHECK CONSTRAINT FK_PDV_VD_TEF_PARC_PDV_VD_TEF 
end





